/*-----------------------------------------------------------------------------
	[VCE.h]

	Copyright (C) 2004 Ki

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
-----------------------------------------------------------------------------*/
#ifndef VCE_H_INCLUDED
#define VCE_H_INCLUDED

#include <stdio.h>
#include "TypeDefs.h"


/*-----------------------------------------------------------------------------
** ֐̃vg^Cv錾sȂ܂D
**---------------------------------------------------------------------------*/
Sint32
VCE_Init();

void
VCE_Deinit();


Uint8
VCE_Read(Uint32 regNum);

void
VCE_Write(
	Uint32		regNum,
	Uint8		data);

void
VCE_EncodeScanLine(
	Uint16*		pBuf,
	Sint32		width);		// W̔{Ŏw肷 

void
VCE_EncodeLine(
	Uint16*			pDst,
	const Uint8*	pSrc,
	const Uint8*	pSpBg,
	Sint32			width);		// W̔{Ŏw肷 

BOOL
VCE_IsHiresolutionMode();

void
VCE_UpdateScreen(
	Uint16*		pBuf,
	Sint32		dispW,
	Sint32		dispH,
	Sint32		topOffset,
	BOOL		bStretched);

BOOL
VCE_SaveState(
	FILE*		p);

BOOL
VCE_LoadState(
	FILE*		p);

#endif		/* VCE_H_INCLUDED */

